package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitAssociationGatewayId,
  TransitGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPeeringAttachmentRequest(
    transitGatewayId: TransitGatewayId,
    peerTransitGatewayId: TransitAssociationGatewayId,
    peerAccountId: String,
    peerRegion: String,
    options: Optional[
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest = {
    import CreateTransitGatewayPeeringAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
      .builder()
      .transitGatewayId(
        TransitGatewayId.unwrap(transitGatewayId): java.lang.String
      )
      .peerTransitGatewayId(
        TransitAssociationGatewayId.unwrap(
          peerTransitGatewayId
        ): java.lang.String
      )
      .peerAccountId(peerAccountId: java.lang.String)
      .peerRegion(peerRegion: java.lang.String)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPeeringAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest =
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest(
        transitGatewayId,
        peerTransitGatewayId,
        peerAccountId,
        peerRegion,
        options.map(value => value.asEditable),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayId: TransitGatewayId
    def peerTransitGatewayId: TransitAssociationGatewayId
    def peerAccountId: String
    def peerRegion: String
    def options: Optional[
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions.ReadOnly
    ]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTransitGatewayId: ZIO[Any, Nothing, TransitGatewayId] =
      ZIO.succeed(transitGatewayId)
    def getPeerTransitGatewayId
        : ZIO[Any, Nothing, TransitAssociationGatewayId] =
      ZIO.succeed(peerTransitGatewayId)
    def getPeerAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(peerAccountId)
    def getPeerRegion: ZIO[Any, Nothing, String] = ZIO.succeed(peerRegion)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest.ReadOnly {
    override val transitGatewayId: TransitGatewayId =
      zio.aws.ec2.model.primitives.TransitGatewayId(impl.transitGatewayId())
    override val peerTransitGatewayId: TransitAssociationGatewayId =
      zio.aws.ec2.model.primitives
        .TransitAssociationGatewayId(impl.peerTransitGatewayId())
    override val peerAccountId: String = impl.peerAccountId(): String
    override val peerRegion: String = impl.peerRegion(): String
    override val options: Optional[
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions
          .wrap(value)
      )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
  ): zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
