package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkInterfacePermissionResponse(
    interfacePermission: Optional[
      zio.aws.ec2.model.NetworkInterfacePermission
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse = {
    import CreateNetworkInterfacePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse
      .builder()
      .optionallyWith(interfacePermission.map(value => value.buildAwsValue()))(
        _.interfacePermission
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse
      .wrap(buildAwsValue())
}
object CreateNetworkInterfacePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse =
      zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse(
        interfacePermission.map(value => value.asEditable)
      )
    def interfacePermission
        : Optional[zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly]
    def getInterfacePermission: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
    ] = AwsError.unwrapOptionField("interfacePermission", interfacePermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse
  ) extends zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly {
    override val interfacePermission
        : Optional[zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interfacePermission())
        .map(value => zio.aws.ec2.model.NetworkInterfacePermission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse
  ): zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly =
    new Wrapper(impl)
}
