package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CoipAddressUsage(
    allocationId: Optional[String] = Optional.Absent,
    awsAccountId: Optional[String] = Optional.Absent,
    awsService: Optional[String] = Optional.Absent,
    coIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CoipAddressUsage = {
    import CoipAddressUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CoipAddressUsage
      .builder()
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(awsAccountId.map(value => value: java.lang.String))(
        _.awsAccountId
      )
      .optionallyWith(awsService.map(value => value: java.lang.String))(
        _.awsService
      )
      .optionallyWith(coIp.map(value => value: java.lang.String))(_.coIp)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CoipAddressUsage.ReadOnly =
    zio.aws.ec2.model.CoipAddressUsage.wrap(buildAwsValue())
}
object CoipAddressUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CoipAddressUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CoipAddressUsage =
      zio.aws.ec2.model.CoipAddressUsage(
        allocationId.map(value => value),
        awsAccountId.map(value => value),
        awsService.map(value => value),
        coIp.map(value => value)
      )
    def allocationId: Optional[String]
    def awsAccountId: Optional[String]
    def awsService: Optional[String]
    def coIp: Optional[String]
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getAwsAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsService: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsService", awsService)
    def getCoIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("coIp", coIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CoipAddressUsage
  ) extends zio.aws.ec2.model.CoipAddressUsage.ReadOnly {
    override val allocationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => value: String)
    override val awsAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => value: String)
    override val awsService: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsService())
      .map(value => value: String)
    override val coIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.coIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CoipAddressUsage
  ): zio.aws.ec2.model.CoipAddressUsage.ReadOnly = new Wrapper(impl)
}
