package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelReservedInstancesListingResponse(
    reservedInstancesListings: Optional[
      Iterable[zio.aws.ec2.model.ReservedInstancesListing]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse = {
    import CancelReservedInstancesListingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse
      .builder()
      .optionallyWith(
        reservedInstancesListings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstancesListings)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly =
    zio.aws.ec2.model.CancelReservedInstancesListingResponse
      .wrap(buildAwsValue())
}
object CancelReservedInstancesListingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelReservedInstancesListingResponse =
      zio.aws.ec2.model.CancelReservedInstancesListingResponse(
        reservedInstancesListings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedInstancesListings
        : Optional[List[zio.aws.ec2.model.ReservedInstancesListing.ReadOnly]]
    def getReservedInstancesListings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesListing.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedInstancesListings",
      reservedInstancesListings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse
  ) extends zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly {
    override val reservedInstancesListings
        : Optional[List[zio.aws.ec2.model.ReservedInstancesListing.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesListings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ReservedInstancesListing.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse
  ): zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly =
    new Wrapper(impl)
}
