package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociatedRole(
    associatedRoleArn: Optional[ResourceArn] = Optional.Absent,
    certificateS3BucketName: Optional[String] = Optional.Absent,
    certificateS3ObjectKey: Optional[String] = Optional.Absent,
    encryptionKmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociatedRole = {
    import AssociatedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociatedRole
      .builder()
      .optionallyWith(
        associatedRoleArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.associatedRoleArn)
      .optionallyWith(
        certificateS3BucketName.map(value => value: java.lang.String)
      )(_.certificateS3BucketName)
      .optionallyWith(
        certificateS3ObjectKey.map(value => value: java.lang.String)
      )(_.certificateS3ObjectKey)
      .optionallyWith(encryptionKmsKeyId.map(value => value: java.lang.String))(
        _.encryptionKmsKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociatedRole.ReadOnly =
    zio.aws.ec2.model.AssociatedRole.wrap(buildAwsValue())
}
object AssociatedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociatedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociatedRole =
      zio.aws.ec2.model.AssociatedRole(
        associatedRoleArn.map(value => value),
        certificateS3BucketName.map(value => value),
        certificateS3ObjectKey.map(value => value),
        encryptionKmsKeyId.map(value => value)
      )
    def associatedRoleArn: Optional[ResourceArn]
    def certificateS3BucketName: Optional[String]
    def certificateS3ObjectKey: Optional[String]
    def encryptionKmsKeyId: Optional[String]
    def getAssociatedRoleArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("associatedRoleArn", associatedRoleArn)
    def getCertificateS3BucketName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateS3BucketName", certificateS3BucketName)
    def getCertificateS3ObjectKey: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateS3ObjectKey", certificateS3ObjectKey)
    def getEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionKmsKeyId", encryptionKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociatedRole
  ) extends zio.aws.ec2.model.AssociatedRole.ReadOnly {
    override val associatedRoleArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedRoleArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val certificateS3BucketName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateS3BucketName())
        .map(value => value: String)
    override val certificateS3ObjectKey: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateS3ObjectKey())
        .map(value => value: String)
    override val encryptionKmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKmsKeyId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociatedRole
  ): zio.aws.ec2.model.AssociatedRole.ReadOnly = new Wrapper(impl)
}
