package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayMulticastDomainResponse(
    associations: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse = {
    import AssociateTransitGatewayMulticastDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
      .builder()
      .optionallyWith(associations.map(value => value.buildAwsValue()))(
        _.associations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly =
    zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayMulticastDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse =
      zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse(
        associations.map(value => value.asEditable)
      )
    def associations: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ]
    def getAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
  ) extends zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly {
    override val associations: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse
  ): zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly =
    new Wrapper(impl)
}
