package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateEnclaveCertificateIamRoleResponse(
    certificateS3BucketName: Optional[String] = Optional.Absent,
    certificateS3ObjectKey: Optional[String] = Optional.Absent,
    encryptionKmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse = {
    import AssociateEnclaveCertificateIamRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse
      .builder()
      .optionallyWith(
        certificateS3BucketName.map(value => value: java.lang.String)
      )(_.certificateS3BucketName)
      .optionallyWith(
        certificateS3ObjectKey.map(value => value: java.lang.String)
      )(_.certificateS3ObjectKey)
      .optionallyWith(encryptionKmsKeyId.map(value => value: java.lang.String))(
        _.encryptionKmsKeyId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly =
    zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse
      .wrap(buildAwsValue())
}
object AssociateEnclaveCertificateIamRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse =
      zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse(
        certificateS3BucketName.map(value => value),
        certificateS3ObjectKey.map(value => value),
        encryptionKmsKeyId.map(value => value)
      )
    def certificateS3BucketName: Optional[String]
    def certificateS3ObjectKey: Optional[String]
    def encryptionKmsKeyId: Optional[String]
    def getCertificateS3BucketName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateS3BucketName", certificateS3BucketName)
    def getCertificateS3ObjectKey: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateS3ObjectKey", certificateS3ObjectKey)
    def getEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionKmsKeyId", encryptionKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse
  ) extends zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly {
    override val certificateS3BucketName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateS3BucketName())
        .map(value => value: String)
    override val certificateS3ObjectKey: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateS3ObjectKey())
        .map(value => value: String)
    override val encryptionKmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKmsKeyId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse
  ): zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly =
    new Wrapper(impl)
}
