package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait UserTrustProviderType {
  def unwrap: software.amazon.awssdk.services.ec2.model.UserTrustProviderType
}
object UserTrustProviderType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.UserTrustProviderType
  ): zio.aws.ec2.model.UserTrustProviderType = value match {
    case software.amazon.awssdk.services.ec2.model.UserTrustProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.UserTrustProviderType.IAM_IDENTITY_CENTER =>
      val r = `iam-identity-center`
      r
    case software.amazon.awssdk.services.ec2.model.UserTrustProviderType.OIDC =>
      val r = oidc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.UserTrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UserTrustProviderType =
      software.amazon.awssdk.services.ec2.model.UserTrustProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object `iam-identity-center`
      extends zio.aws.ec2.model.UserTrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UserTrustProviderType =
      software.amazon.awssdk.services.ec2.model.UserTrustProviderType.IAM_IDENTITY_CENTER
  }
  case object oidc extends zio.aws.ec2.model.UserTrustProviderType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UserTrustProviderType =
      software.amazon.awssdk.services.ec2.model.UserTrustProviderType.OIDC
  }
}
