package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayRouteState {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState
}
object TransitGatewayRouteState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState
  ): zio.aws.ec2.model.TransitGatewayRouteState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.BLACKHOLE =>
      val r = blackhole
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.TransitGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.PENDING
  }
  case object active extends zio.aws.ec2.model.TransitGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.ACTIVE
  }
  case object blackhole extends zio.aws.ec2.model.TransitGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.BLACKHOLE
  }
  case object deleting extends zio.aws.ec2.model.TransitGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.TransitGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteState.DELETED
  }
}
