package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayConnectPeerState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState
}
object TransitGatewayConnectPeerState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState
  ): zio.aws.ec2.model.TransitGatewayConnectPeerState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.TransitGatewayConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.PENDING
  }
  case object available
      extends zio.aws.ec2.model.TransitGatewayConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.AVAILABLE
  }
  case object deleting
      extends zio.aws.ec2.model.TransitGatewayConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.TransitGatewayConnectPeerState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeerState.DELETED
  }
}
