package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrafficMirrorFilter(
    trafficMirrorFilterId: Optional[String] = Optional.Absent,
    ingressFilterRules: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilterRule]
    ] = Optional.Absent,
    egressFilterRules: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilterRule]
    ] = Optional.Absent,
    networkServices: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorNetworkService]
    ] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter = {
    import TrafficMirrorFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
      .builder()
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .optionallyWith(
        ingressFilterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ingressFilterRules)
      .optionallyWith(
        egressFilterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.egressFilterRules)
      .optionallyWith(
        networkServices.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.networkServicesWithStrings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorFilter.wrap(buildAwsValue())
}
object TrafficMirrorFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorFilter =
      zio.aws.ec2.model.TrafficMirrorFilter(
        trafficMirrorFilterId.map(value => value),
        ingressFilterRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        egressFilterRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkServices.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficMirrorFilterId: Optional[String]
    def ingressFilterRules
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]]
    def egressFilterRules
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]]
    def networkServices
        : Optional[List[zio.aws.ec2.model.TrafficMirrorNetworkService]]
    def description: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getIngressFilterRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly
    ]] = AwsError.unwrapOptionField("ingressFilterRules", ingressFilterRules)
    def getEgressFilterRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly
    ]] = AwsError.unwrapOptionField("egressFilterRules", egressFilterRules)
    def getNetworkServices: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorNetworkService
    ]] = AwsError.unwrapOptionField("networkServices", networkServices)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
  ) extends zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly {
    override val trafficMirrorFilterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficMirrorFilterId())
      .map(value => value: String)
    override val ingressFilterRules
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingressFilterRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(item)
          }.toList
        )
    override val egressFilterRules
        : Optional[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressFilterRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(item)
          }.toList
        )
    override val networkServices
        : Optional[List[zio.aws.ec2.model.TrafficMirrorNetworkService]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorNetworkService.wrap(item)
          }.toList
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
  ): zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly = new Wrapper(impl)
}
