package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetCapacitySpecification(
    totalTargetCapacity: Optional[Integer] = Optional.Absent,
    onDemandTargetCapacity: Optional[Integer] = Optional.Absent,
    spotTargetCapacity: Optional[Integer] = Optional.Absent,
    defaultTargetCapacityType: Optional[
      zio.aws.ec2.model.DefaultTargetCapacityType
    ] = Optional.Absent,
    targetCapacityUnitType: Optional[zio.aws.ec2.model.TargetCapacityUnitType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification = {
    import TargetCapacitySpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
      .builder()
      .optionallyWith(
        totalTargetCapacity.map(value => value: java.lang.Integer)
      )(_.totalTargetCapacity)
      .optionallyWith(
        onDemandTargetCapacity.map(value => value: java.lang.Integer)
      )(_.onDemandTargetCapacity)
      .optionallyWith(
        spotTargetCapacity.map(value => value: java.lang.Integer)
      )(_.spotTargetCapacity)
      .optionallyWith(defaultTargetCapacityType.map(value => value.unwrap))(
        _.defaultTargetCapacityType
      )
      .optionallyWith(targetCapacityUnitType.map(value => value.unwrap))(
        _.targetCapacityUnitType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly =
    zio.aws.ec2.model.TargetCapacitySpecification.wrap(buildAwsValue())
}
object TargetCapacitySpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetCapacitySpecification =
      zio.aws.ec2.model.TargetCapacitySpecification(
        totalTargetCapacity.map(value => value),
        onDemandTargetCapacity.map(value => value),
        spotTargetCapacity.map(value => value),
        defaultTargetCapacityType.map(value => value),
        targetCapacityUnitType.map(value => value)
      )
    def totalTargetCapacity: Optional[Integer]
    def onDemandTargetCapacity: Optional[Integer]
    def spotTargetCapacity: Optional[Integer]
    def defaultTargetCapacityType
        : Optional[zio.aws.ec2.model.DefaultTargetCapacityType]
    def targetCapacityUnitType
        : Optional[zio.aws.ec2.model.TargetCapacityUnitType]
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getOnDemandTargetCapacity: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("onDemandTargetCapacity", onDemandTargetCapacity)
    def getSpotTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("spotTargetCapacity", spotTargetCapacity)
    def getDefaultTargetCapacityType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DefaultTargetCapacityType] =
      AwsError.unwrapOptionField(
        "defaultTargetCapacityType",
        defaultTargetCapacityType
      )
    def getTargetCapacityUnitType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetCapacityUnitType] =
      AwsError.unwrapOptionField(
        "targetCapacityUnitType",
        targetCapacityUnitType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
  ) extends zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly {
    override val totalTargetCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalTargetCapacity())
      .map(value => value: Integer)
    override val onDemandTargetCapacity: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandTargetCapacity())
        .map(value => value: Integer)
    override val spotTargetCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.spotTargetCapacity())
      .map(value => value: Integer)
    override val defaultTargetCapacityType
        : Optional[zio.aws.ec2.model.DefaultTargetCapacityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTargetCapacityType())
        .map(value => zio.aws.ec2.model.DefaultTargetCapacityType.wrap(value))
    override val targetCapacityUnitType
        : Optional[zio.aws.ec2.model.TargetCapacityUnitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetCapacityUnitType())
        .map(value => zio.aws.ec2.model.TargetCapacityUnitType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
  ): zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly = new Wrapper(impl)
}
