package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupRuleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupRuleUpdate(
    securityGroupRuleId: Optional[SecurityGroupRuleId] = Optional.Absent,
    securityGroupRule: Optional[zio.aws.ec2.model.SecurityGroupRuleRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate = {
    import SecurityGroupRuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
      .builder()
      .optionallyWith(
        securityGroupRuleId.map(value =>
          SecurityGroupRuleId.unwrap(value): java.lang.String
        )
      )(_.securityGroupRuleId)
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRuleUpdate.wrap(buildAwsValue())
}
object SecurityGroupRuleUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRuleUpdate =
      zio.aws.ec2.model.SecurityGroupRuleUpdate(
        securityGroupRuleId.map(value => value),
        securityGroupRule.map(value => value.asEditable)
      )
    def securityGroupRuleId: Optional[SecurityGroupRuleId]
    def securityGroupRule
        : Optional[zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly]
    def getSecurityGroupRuleId: ZIO[Any, AwsError, SecurityGroupRuleId] =
      AwsError.unwrapOptionField("securityGroupRuleId", securityGroupRuleId)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ) extends zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly {
    override val securityGroupRuleId: Optional[SecurityGroupRuleId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRuleId())
        .map(value => zio.aws.ec2.model.primitives.SecurityGroupRuleId(value))
    override val securityGroupRule
        : Optional[zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRule())
        .map(value => zio.aws.ec2.model.SecurityGroupRuleRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ): zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly = new Wrapper(impl)
}
