package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreAddressToClassicResponse(
    publicIp: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse = {
    import RestoreAddressToClassicResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse
      .builder()
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly =
    zio.aws.ec2.model.RestoreAddressToClassicResponse.wrap(buildAwsValue())
}
object RestoreAddressToClassicResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreAddressToClassicResponse =
      zio.aws.ec2.model.RestoreAddressToClassicResponse(
        publicIp.map(value => value),
        status.map(value => value)
      )
    def publicIp: Optional[String]
    def status: Optional[zio.aws.ec2.model.Status]
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse
  ) extends zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly {
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val status: Optional[zio.aws.ec2.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse
  ): zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly = new Wrapper(
    impl
  )
}
