package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReleaseAddressRequest(
    allocationId: Optional[AllocationId] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent,
    networkBorderGroup: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest = {
    import ReleaseAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest
      .builder()
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReleaseAddressRequest.ReadOnly =
    zio.aws.ec2.model.ReleaseAddressRequest.wrap(buildAwsValue())
}
object ReleaseAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReleaseAddressRequest =
      zio.aws.ec2.model.ReleaseAddressRequest(
        allocationId.map(value => value),
        publicIp.map(value => value),
        networkBorderGroup.map(value => value)
      )
    def allocationId: Optional[AllocationId]
    def publicIp: Optional[String]
    def networkBorderGroup: Optional[String]
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest
  ) extends zio.aws.ec2.model.ReleaseAddressRequest.ReadOnly {
    override val allocationId: Optional[AllocationId] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => zio.aws.ec2.model.primitives.AllocationId(value))
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val networkBorderGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkBorderGroup())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest
  ): zio.aws.ec2.model.ReleaseAddressRequest.ReadOnly = new Wrapper(impl)
}
