package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PlacementGroupState {
  def unwrap: software.amazon.awssdk.services.ec2.model.PlacementGroupState
}
object PlacementGroupState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PlacementGroupState
  ): zio.aws.ec2.model.PlacementGroupState = value match {
    case software.amazon.awssdk.services.ec2.model.PlacementGroupState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.PlacementGroupState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.PlacementGroupState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupState =
      software.amazon.awssdk.services.ec2.model.PlacementGroupState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.PlacementGroupState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupState =
      software.amazon.awssdk.services.ec2.model.PlacementGroupState.PENDING
  }
  case object available extends zio.aws.ec2.model.PlacementGroupState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupState =
      software.amazon.awssdk.services.ec2.model.PlacementGroupState.AVAILABLE
  }
  case object deleting extends zio.aws.ec2.model.PlacementGroupState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupState =
      software.amazon.awssdk.services.ec2.model.PlacementGroupState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.PlacementGroupState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementGroupState =
      software.amazon.awssdk.services.ec2.model.PlacementGroupState.DELETED
  }
}
