package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait OnDemandAllocationStrategy {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy
}
object OnDemandAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy
  ): zio.aws.ec2.model.OnDemandAllocationStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy.LOWEST_PRICE =>
      val r = lowestPrice
      r
    case software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy.PRIORITIZED =>
      val r = prioritized
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.OnDemandAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object lowestPrice extends zio.aws.ec2.model.OnDemandAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy.LOWEST_PRICE
  }
  case object prioritized extends zio.aws.ec2.model.OnDemandAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.OnDemandAllocationStrategy.PRIORITIZED
  }
}
