package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServicePayerResponsibilityRequest(
    serviceId: VpcEndpointServiceId,
    payerResponsibility: zio.aws.ec2.model.PayerResponsibility
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest = {
    import ModifyVpcEndpointServicePayerResponsibilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest
      .builder()
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .payerResponsibility(payerResponsibility.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServicePayerResponsibilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest =
      zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest(
        serviceId,
        payerResponsibility
      )
    def serviceId: VpcEndpointServiceId
    def payerResponsibility: zio.aws.ec2.model.PayerResponsibility
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getPayerResponsibility
        : ZIO[Any, Nothing, zio.aws.ec2.model.PayerResponsibility] =
      ZIO.succeed(payerResponsibility)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest.ReadOnly {
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val payerResponsibility: zio.aws.ec2.model.PayerResponsibility =
      zio.aws.ec2.model.PayerResponsibility.wrap(impl.payerResponsibility())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest.ReadOnly =
    new Wrapper(impl)
}
