package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessInstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessInstanceRequest(
    verifiedAccessInstanceId: VerifiedAccessInstanceId,
    description: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest = {
    import ModifyVerifiedAccessInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest
      .builder()
      .verifiedAccessInstanceId(
        VerifiedAccessInstanceId.unwrap(
          verifiedAccessInstanceId
        ): java.lang.String
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessInstanceRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessInstanceRequest.wrap(buildAwsValue())
}
object ModifyVerifiedAccessInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessInstanceRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessInstanceRequest(
        verifiedAccessInstanceId,
        description.map(value => value),
        clientToken.map(value => value)
      )
    def verifiedAccessInstanceId: VerifiedAccessInstanceId
    def description: Optional[String]
    def clientToken: Optional[String]
    def getVerifiedAccessInstanceId
        : ZIO[Any, Nothing, VerifiedAccessInstanceId] =
      ZIO.succeed(verifiedAccessInstanceId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessInstanceRequest.ReadOnly {
    override val verifiedAccessInstanceId: VerifiedAccessInstanceId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessInstanceId(impl.verifiedAccessInstanceId())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
