package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class MetricPoint(
    startDate: Optional[MillisecondDateTime] = Optional.Absent,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    value: Optional[Float] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.MetricPoint = {
    import MetricPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MetricPoint
      .builder()
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(value.map(value => value: java.lang.Float))(_.value)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MetricPoint.ReadOnly =
    zio.aws.ec2.model.MetricPoint.wrap(buildAwsValue())
}
object MetricPoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.MetricPoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MetricPoint =
      zio.aws.ec2.model.MetricPoint(
        startDate.map(value => value),
        endDate.map(value => value),
        value.map(value => value),
        status.map(value => value)
      )
    def startDate: Optional[MillisecondDateTime]
    def endDate: Optional[MillisecondDateTime]
    def value: Optional[Float]
    def status: Optional[String]
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MetricPoint
  ) extends zio.aws.ec2.model.MetricPoint.ReadOnly {
    override val startDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val value: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Float)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MetricPoint
  ): zio.aws.ec2.model.MetricPoint.ReadOnly = new Wrapper(impl)
}
