package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemoryGiBPerVCpu(
    min: Optional[Double] = Optional.Absent,
    max: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MemoryGiBPerVCpu = {
    import MemoryGiBPerVCpu.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MemoryGiBPerVCpu
      .builder()
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly =
    zio.aws.ec2.model.MemoryGiBPerVCpu.wrap(buildAwsValue())
}
object MemoryGiBPerVCpu {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MemoryGiBPerVCpu
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MemoryGiBPerVCpu = zio.aws.ec2.model
      .MemoryGiBPerVCpu(min.map(value => value), max.map(value => value))
    def min: Optional[Double]
    def max: Optional[Double]
    def getMin: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MemoryGiBPerVCpu
  ) extends zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly {
    override val min: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Double)
    override val max: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MemoryGiBPerVCpu
  ): zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly = new Wrapper(impl)
}
