package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateInstanceMetadataProtocolIpv6 {
  def unwrap: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6
}
object LaunchTemplateInstanceMetadataProtocolIpv6 {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6
  ): zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 =
    value match {
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6.DISABLED =>
        val r = disabled
        r
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6.ENABLED =>
        val r = enabled
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6.DISABLED
  }
  case object enabled
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6 =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataProtocolIpv6.ENABLED
  }
}
