package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamResourceDiscoveryAssociationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState
}
object IpamResourceDiscoveryAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState
  ): zio.aws.ec2.model.IpamResourceDiscoveryAssociationState = value match {
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ASSOCIATE_IN_PROGRESS =>
      val r = `associate-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ASSOCIATE_COMPLETE =>
      val r = `associate-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ASSOCIATE_FAILED =>
      val r = `associate-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.DISASSOCIATE_IN_PROGRESS =>
      val r = `disassociate-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.DISASSOCIATE_COMPLETE =>
      val r = `disassociate-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.DISASSOCIATE_FAILED =>
      val r = `disassociate-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ISOLATE_IN_PROGRESS =>
      val r = `isolate-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ISOLATE_COMPLETE =>
      val r = `isolate-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.RESTORE_IN_PROGRESS =>
      val r = `restore-in-progress`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object `associate-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ASSOCIATE_IN_PROGRESS
  }
  case object `associate-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ASSOCIATE_COMPLETE
  }
  case object `associate-failed`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ASSOCIATE_FAILED
  }
  case object `disassociate-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.DISASSOCIATE_IN_PROGRESS
  }
  case object `disassociate-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.DISASSOCIATE_COMPLETE
  }
  case object `disassociate-failed`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.DISASSOCIATE_FAILED
  }
  case object `isolate-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ISOLATE_IN_PROGRESS
  }
  case object `isolate-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.ISOLATE_COMPLETE
  }
  case object `restore-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationState.RESTORE_IN_PROGRESS
  }
}
