package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceMaintenanceOptionsRequest(
    autoRecovery: Optional[zio.aws.ec2.model.InstanceAutoRecoveryState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptionsRequest = {
    import InstanceMaintenanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptionsRequest
      .builder()
      .optionallyWith(autoRecovery.map(value => value.unwrap))(_.autoRecovery)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.ReadOnly =
    zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.wrap(buildAwsValue())
}
object InstanceMaintenanceOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceMaintenanceOptionsRequest =
      zio.aws.ec2.model
        .InstanceMaintenanceOptionsRequest(autoRecovery.map(value => value))
    def autoRecovery: Optional[zio.aws.ec2.model.InstanceAutoRecoveryState]
    def getAutoRecovery
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceAutoRecoveryState] =
      AwsError.unwrapOptionField("autoRecovery", autoRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptionsRequest
  ) extends zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.ReadOnly {
    override val autoRecovery
        : Optional[zio.aws.ec2.model.InstanceAutoRecoveryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRecovery())
        .map(value => zio.aws.ec2.model.InstanceAutoRecoveryState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptionsRequest
  ): zio.aws.ec2.model.InstanceMaintenanceOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
