package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class Host(
    autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    availableCapacity: Optional[zio.aws.ec2.model.AvailableCapacity] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    hostId: Optional[String] = Optional.Absent,
    hostProperties: Optional[zio.aws.ec2.model.HostProperties] =
      Optional.Absent,
    hostReservationId: Optional[String] = Optional.Absent,
    instances: Optional[Iterable[zio.aws.ec2.model.HostInstance]] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.AllocationState] = Optional.Absent,
    allocationTime: Optional[DateTime] = Optional.Absent,
    releaseTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    hostRecovery: Optional[zio.aws.ec2.model.HostRecovery] = Optional.Absent,
    allowsMultipleInstanceTypes: Optional[
      zio.aws.ec2.model.AllowsMultipleInstanceTypes
    ] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    memberOfServiceLinkedResourceGroup: Optional[Boolean] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Host
      .builder()
      .optionallyWith(autoPlacement.map(value => value.unwrap))(_.autoPlacement)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availableCapacity.map(value => value.buildAwsValue()))(
        _.availableCapacity
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(hostId.map(value => value: java.lang.String))(_.hostId)
      .optionallyWith(hostProperties.map(value => value.buildAwsValue()))(
        _.hostProperties
      )
      .optionallyWith(hostReservationId.map(value => value: java.lang.String))(
        _.hostReservationId
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        allocationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.allocationTime)
      .optionallyWith(
        releaseTime.map(value => DateTime.unwrap(value): Instant)
      )(_.releaseTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(hostRecovery.map(value => value.unwrap))(_.hostRecovery)
      .optionallyWith(allowsMultipleInstanceTypes.map(value => value.unwrap))(
        _.allowsMultipleInstanceTypes
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(
        memberOfServiceLinkedResourceGroup.map(value =>
          value: java.lang.Boolean
        )
      )(_.memberOfServiceLinkedResourceGroup)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Host.ReadOnly =
    zio.aws.ec2.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Host] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Host = zio.aws.ec2.model.Host(
      autoPlacement.map(value => value),
      availabilityZone.map(value => value),
      availableCapacity.map(value => value.asEditable),
      clientToken.map(value => value),
      hostId.map(value => value),
      hostProperties.map(value => value.asEditable),
      hostReservationId.map(value => value),
      instances.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      state.map(value => value),
      allocationTime.map(value => value),
      releaseTime.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      hostRecovery.map(value => value),
      allowsMultipleInstanceTypes.map(value => value),
      ownerId.map(value => value),
      availabilityZoneId.map(value => value),
      memberOfServiceLinkedResourceGroup.map(value => value),
      outpostArn.map(value => value)
    )
    def autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement]
    def availabilityZone: Optional[String]
    def availableCapacity
        : Optional[zio.aws.ec2.model.AvailableCapacity.ReadOnly]
    def clientToken: Optional[String]
    def hostId: Optional[String]
    def hostProperties: Optional[zio.aws.ec2.model.HostProperties.ReadOnly]
    def hostReservationId: Optional[String]
    def instances: Optional[List[zio.aws.ec2.model.HostInstance.ReadOnly]]
    def state: Optional[zio.aws.ec2.model.AllocationState]
    def allocationTime: Optional[DateTime]
    def releaseTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def hostRecovery: Optional[zio.aws.ec2.model.HostRecovery]
    def allowsMultipleInstanceTypes
        : Optional[zio.aws.ec2.model.AllowsMultipleInstanceTypes]
    def ownerId: Optional[String]
    def availabilityZoneId: Optional[String]
    def memberOfServiceLinkedResourceGroup: Optional[Boolean]
    def outpostArn: Optional[String]
    def getAutoPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.AutoPlacement] =
      AwsError.unwrapOptionField("autoPlacement", autoPlacement)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailableCapacity
        : ZIO[Any, AwsError, zio.aws.ec2.model.AvailableCapacity.ReadOnly] =
      AwsError.unwrapOptionField("availableCapacity", availableCapacity)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getHostId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getHostProperties
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostProperties.ReadOnly] =
      AwsError.unwrapOptionField("hostProperties", hostProperties)
    def getHostReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostReservationId", hostReservationId)
    def getInstances
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.HostInstance.ReadOnly]] =
      AwsError.unwrapOptionField("instances", instances)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AllocationState] =
      AwsError.unwrapOptionField("state", state)
    def getAllocationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("allocationTime", allocationTime)
    def getReleaseTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("releaseTime", releaseTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getHostRecovery: ZIO[Any, AwsError, zio.aws.ec2.model.HostRecovery] =
      AwsError.unwrapOptionField("hostRecovery", hostRecovery)
    def getAllowsMultipleInstanceTypes
        : ZIO[Any, AwsError, zio.aws.ec2.model.AllowsMultipleInstanceTypes] =
      AwsError.unwrapOptionField(
        "allowsMultipleInstanceTypes",
        allowsMultipleInstanceTypes
      )
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getMemberOfServiceLinkedResourceGroup: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "memberOfServiceLinkedResourceGroup",
        memberOfServiceLinkedResourceGroup
      )
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Host
  ) extends zio.aws.ec2.model.Host.ReadOnly {
    override val autoPlacement: Optional[zio.aws.ec2.model.AutoPlacement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoPlacement())
        .map(value => zio.aws.ec2.model.AutoPlacement.wrap(value))
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availableCapacity
        : Optional[zio.aws.ec2.model.AvailableCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableCapacity())
        .map(value => zio.aws.ec2.model.AvailableCapacity.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val hostId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostId())
      .map(value => value: String)
    override val hostProperties
        : Optional[zio.aws.ec2.model.HostProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostProperties())
        .map(value => zio.aws.ec2.model.HostProperties.wrap(value))
    override val hostReservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostReservationId())
      .map(value => value: String)
    override val instances
        : Optional[List[zio.aws.ec2.model.HostInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.HostInstance.wrap(item)
          }.toList
        )
    override val state: Optional[zio.aws.ec2.model.AllocationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.AllocationState.wrap(value))
    override val allocationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val releaseTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val hostRecovery: Optional[zio.aws.ec2.model.HostRecovery] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostRecovery())
        .map(value => zio.aws.ec2.model.HostRecovery.wrap(value))
    override val allowsMultipleInstanceTypes
        : Optional[zio.aws.ec2.model.AllowsMultipleInstanceTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsMultipleInstanceTypes())
        .map(value => zio.aws.ec2.model.AllowsMultipleInstanceTypes.wrap(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val memberOfServiceLinkedResourceGroup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberOfServiceLinkedResourceGroup())
        .map(value => value: Boolean)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Host
  ): zio.aws.ec2.model.Host.ReadOnly = new Wrapper(impl)
}
