package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportClientVpnClientCertificateRevocationListResponse(
    certificateRevocationList: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ClientCertificateRevocationListStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse = {
    import ExportClientVpnClientCertificateRevocationListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse
      .builder()
      .optionallyWith(
        certificateRevocationList.map(value => value: java.lang.String)
      )(_.certificateRevocationList)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly =
    zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse
      .wrap(buildAwsValue())
}
object ExportClientVpnClientCertificateRevocationListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse =
      zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse(
        certificateRevocationList.map(value => value),
        status.map(value => value.asEditable)
      )
    def certificateRevocationList: Optional[String]
    def status: Optional[
      zio.aws.ec2.model.ClientCertificateRevocationListStatus.ReadOnly
    ]
    def getCertificateRevocationList: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateRevocationList", certificateRevocationList)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientCertificateRevocationListStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse
  ) extends zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly {
    override val certificateRevocationList: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateRevocationList())
        .map(value => value: String)
    override val status: Optional[
      zio.aws.ec2.model.ClientCertificateRevocationListStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.ec2.model.ClientCertificateRevocationListStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse
  ): zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly =
    new Wrapper(impl)
}
