package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EbsInstanceBlockDeviceSpecification(
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    volumeId: Optional[VolumeId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification = {
    import EbsInstanceBlockDeviceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification
      .builder()
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EbsInstanceBlockDeviceSpecification.ReadOnly =
    zio.aws.ec2.model.EbsInstanceBlockDeviceSpecification.wrap(buildAwsValue())
}
object EbsInstanceBlockDeviceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EbsInstanceBlockDeviceSpecification =
      zio.aws.ec2.model.EbsInstanceBlockDeviceSpecification(
        deleteOnTermination.map(value => value),
        volumeId.map(value => value)
      )
    def deleteOnTermination: Optional[Boolean]
    def volumeId: Optional[VolumeId]
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification
  ) extends zio.aws.ec2.model.EbsInstanceBlockDeviceSpecification.ReadOnly {
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val volumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => zio.aws.ec2.model.primitives.VolumeId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification
  ): zio.aws.ec2.model.EbsInstanceBlockDeviceSpecification.ReadOnly =
    new Wrapper(impl)
}
