package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcCidrAssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateVpcCidrBlockRequest(
    associationId: VpcCidrAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest = {
    import DisassociateVpcCidrBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest
      .builder()
      .associationId(
        VpcCidrAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateVpcCidrBlockRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateVpcCidrBlockRequest.wrap(buildAwsValue())
}
object DisassociateVpcCidrBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateVpcCidrBlockRequest =
      zio.aws.ec2.model.DisassociateVpcCidrBlockRequest(associationId)
    def associationId: VpcCidrAssociationId
    def getAssociationId: ZIO[Any, Nothing, VpcCidrAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest
  ) extends zio.aws.ec2.model.DisassociateVpcCidrBlockRequest.ReadOnly {
    override val associationId: VpcCidrAssociationId =
      zio.aws.ec2.model.primitives.VpcCidrAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest
  ): zio.aws.ec2.model.DisassociateVpcCidrBlockRequest.ReadOnly = new Wrapper(
    impl
  )
}
