package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.RouteTableAssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateRouteTableRequest(
    associationId: RouteTableAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest = {
    import DisassociateRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest
      .builder()
      .associationId(
        RouteTableAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateRouteTableRequest.wrap(buildAwsValue())
}
object DisassociateRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateRouteTableRequest =
      zio.aws.ec2.model.DisassociateRouteTableRequest(associationId)
    def associationId: RouteTableAssociationId
    def getAssociationId: ZIO[Any, Nothing, RouteTableAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest
  ) extends zio.aws.ec2.model.DisassociateRouteTableRequest.ReadOnly {
    override val associationId: RouteTableAssociationId =
      zio.aws.ec2.model.primitives.RouteTableAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest
  ): zio.aws.ec2.model.DisassociateRouteTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
