package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DestinationOptionsRequest(
    fileFormat: Optional[zio.aws.ec2.model.DestinationFileFormat] =
      Optional.Absent,
    hiveCompatiblePartitions: Optional[Boolean] = Optional.Absent,
    perHourPartition: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DestinationOptionsRequest = {
    import DestinationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DestinationOptionsRequest
      .builder()
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        hiveCompatiblePartitions.map(value => value: java.lang.Boolean)
      )(_.hiveCompatiblePartitions)
      .optionallyWith(perHourPartition.map(value => value: java.lang.Boolean))(
        _.perHourPartition
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly =
    zio.aws.ec2.model.DestinationOptionsRequest.wrap(buildAwsValue())
}
object DestinationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DestinationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DestinationOptionsRequest =
      zio.aws.ec2.model.DestinationOptionsRequest(
        fileFormat.map(value => value),
        hiveCompatiblePartitions.map(value => value),
        perHourPartition.map(value => value)
      )
    def fileFormat: Optional[zio.aws.ec2.model.DestinationFileFormat]
    def hiveCompatiblePartitions: Optional[Boolean]
    def perHourPartition: Optional[Boolean]
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.ec2.model.DestinationFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getHiveCompatiblePartitions: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("hiveCompatiblePartitions", hiveCompatiblePartitions)
    def getPerHourPartition: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("perHourPartition", perHourPartition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DestinationOptionsRequest
  ) extends zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly {
    override val fileFormat: Optional[zio.aws.ec2.model.DestinationFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value => zio.aws.ec2.model.DestinationFileFormat.wrap(value))
    override val hiveCompatiblePartitions: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hiveCompatiblePartitions())
        .map(value => value: Boolean)
    override val perHourPartition: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.perHourPartition())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DestinationOptionsRequest
  ): zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly = new Wrapper(impl)
}
