package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessInstancesResponse(
    verifiedAccessInstances: Optional[
      Iterable[zio.aws.ec2.model.VerifiedAccessInstance]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse = {
    import DescribeVerifiedAccessInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse
      .builder()
      .optionallyWith(
        verifiedAccessInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verifiedAccessInstances)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVerifiedAccessInstancesResponse =
      zio.aws.ec2.model.DescribeVerifiedAccessInstancesResponse(
        verifiedAccessInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def verifiedAccessInstances
        : Optional[List[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVerifiedAccessInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "verifiedAccessInstances",
      verifiedAccessInstances
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessInstancesResponse.ReadOnly {
    override val verifiedAccessInstances
        : Optional[List[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VerifiedAccessInstance.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse
  ): zio.aws.ec2.model.DescribeVerifiedAccessInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
