package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeVerifiedAccessInstancesMaxResults,
  VerifiedAccessInstanceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessInstancesRequest(
    verifiedAccessInstanceIds: Optional[Iterable[VerifiedAccessInstanceId]] =
      Optional.Absent,
    maxResults: Optional[DescribeVerifiedAccessInstancesMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest = {
    import DescribeVerifiedAccessInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest
      .builder()
      .optionallyWith(
        verifiedAccessInstanceIds.map(value =>
          value.map { item =>
            VerifiedAccessInstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.verifiedAccessInstanceIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeVerifiedAccessInstancesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessInstancesRequest
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVerifiedAccessInstancesRequest =
      zio.aws.ec2.model.DescribeVerifiedAccessInstancesRequest(
        verifiedAccessInstanceIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def verifiedAccessInstanceIds: Optional[List[VerifiedAccessInstanceId]]
    def maxResults: Optional[DescribeVerifiedAccessInstancesMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getVerifiedAccessInstanceIds
        : ZIO[Any, AwsError, List[VerifiedAccessInstanceId]] = AwsError
      .unwrapOptionField("verifiedAccessInstanceIds", verifiedAccessInstanceIds)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeVerifiedAccessInstancesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessInstancesRequest.ReadOnly {
    override val verifiedAccessInstanceIds
        : Optional[List[VerifiedAccessInstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessInstanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VerifiedAccessInstanceId(item)
        }.toList
      )
    override val maxResults
        : Optional[DescribeVerifiedAccessInstancesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVerifiedAccessInstancesMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest
  ): zio.aws.ec2.model.DescribeVerifiedAccessInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
