package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeVerifiedAccessGroupMaxResults,
  VerifiedAccessInstanceId,
  VerifiedAccessGroupId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessGroupsRequest(
    verifiedAccessGroupIds: Optional[Iterable[VerifiedAccessGroupId]] =
      Optional.Absent,
    verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId] =
      Optional.Absent,
    maxResults: Optional[DescribeVerifiedAccessGroupMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest = {
    import DescribeVerifiedAccessGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest
      .builder()
      .optionallyWith(
        verifiedAccessGroupIds.map(value =>
          value.map { item =>
            VerifiedAccessGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.verifiedAccessGroupIds)
      .optionallyWith(
        verifiedAccessInstanceId.map(value =>
          VerifiedAccessInstanceId.unwrap(value): java.lang.String
        )
      )(_.verifiedAccessInstanceId)
      .optionallyWith(
        maxResults.map(value =>
          DescribeVerifiedAccessGroupMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessGroupsRequest.wrap(buildAwsValue())
}
object DescribeVerifiedAccessGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVerifiedAccessGroupsRequest =
      zio.aws.ec2.model.DescribeVerifiedAccessGroupsRequest(
        verifiedAccessGroupIds.map(value => value),
        verifiedAccessInstanceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def verifiedAccessGroupIds: Optional[List[VerifiedAccessGroupId]]
    def verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId]
    def maxResults: Optional[DescribeVerifiedAccessGroupMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getVerifiedAccessGroupIds
        : ZIO[Any, AwsError, List[VerifiedAccessGroupId]] = AwsError
      .unwrapOptionField("verifiedAccessGroupIds", verifiedAccessGroupIds)
    def getVerifiedAccessInstanceId
        : ZIO[Any, AwsError, VerifiedAccessInstanceId] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeVerifiedAccessGroupMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessGroupsRequest.ReadOnly {
    override val verifiedAccessGroupIds: Optional[List[VerifiedAccessGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.VerifiedAccessGroupId(item)
          }.toList
        )
    override val verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessInstanceId(value)
        )
    override val maxResults: Optional[DescribeVerifiedAccessGroupMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVerifiedAccessGroupMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest
  ): zio.aws.ec2.model.DescribeVerifiedAccessGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
