package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  LaunchTemplateName,
  LaunchTemplateId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLaunchTemplateVersionsRequest(
    launchTemplateId: Optional[LaunchTemplateId] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    versions: Optional[Iterable[String]] = Optional.Absent,
    minVersion: Optional[String] = Optional.Absent,
    maxVersion: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    resolveAlias: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest = {
    import DescribeLaunchTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(minVersion.map(value => value: java.lang.String))(
        _.minVersion
      )
      .optionallyWith(maxVersion.map(value => value: java.lang.String))(
        _.maxVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(resolveAlias.map(value => value: java.lang.Boolean))(
        _.resolveAlias
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeLaunchTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest =
      zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versions.map(value => value),
        minVersion.map(value => value),
        maxVersion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resolveAlias.map(value => value)
      )
    def launchTemplateId: Optional[LaunchTemplateId]
    def launchTemplateName: Optional[LaunchTemplateName]
    def versions: Optional[List[String]]
    def minVersion: Optional[String]
    def maxVersion: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[Integer]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def resolveAlias: Optional[Boolean]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("versions", versions)
    def getMinVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minVersion", minVersion)
    def getMaxVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxVersion", maxVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getResolveAlias: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resolveAlias", resolveAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
  ) extends zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest.ReadOnly {
    override val launchTemplateId: Optional[LaunchTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateId())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val versions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val minVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minVersion())
      .map(value => value: String)
    override val maxVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxVersion())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val resolveAlias: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resolveAlias())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
  ): zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
