package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolCoipId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCoipCidrRequest(
    cidr: String,
    coipPoolId: Ipv4PoolCoipId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest = {
    import DeleteCoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .coipPoolId(Ipv4PoolCoipId.unwrap(coipPoolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCoipCidrRequest.wrap(buildAwsValue())
}
object DeleteCoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCoipCidrRequest =
      zio.aws.ec2.model.DeleteCoipCidrRequest(cidr, coipPoolId)
    def cidr: String
    def coipPoolId: Ipv4PoolCoipId
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getCoipPoolId: ZIO[Any, Nothing, Ipv4PoolCoipId] =
      ZIO.succeed(coipPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
  ) extends zio.aws.ec2.model.DeleteCoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val coipPoolId: Ipv4PoolCoipId =
      zio.aws.ec2.model.primitives.Ipv4PoolCoipId(impl.coipPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest
  ): zio.aws.ec2.model.DeleteCoipCidrRequest.ReadOnly = new Wrapper(impl)
}
