package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DefaultRouteTablePropagationValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue
}
object DefaultRouteTablePropagationValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue
  ): zio.aws.ec2.model.DefaultRouteTablePropagationValue = value match {
    case software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DefaultRouteTablePropagationValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue =
      software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable
      extends zio.aws.ec2.model.DefaultRouteTablePropagationValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue =
      software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue.ENABLE
  }
  case object disable
      extends zio.aws.ec2.model.DefaultRouteTablePropagationValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue =
      software.amazon.awssdk.services.ec2.model.DefaultRouteTablePropagationValue.DISABLE
  }
}
