package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorFilterResponse(
    trafficMirrorFilter: Optional[zio.aws.ec2.model.TrafficMirrorFilter] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse = {
    import CreateTrafficMirrorFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
      .builder()
      .optionallyWith(trafficMirrorFilter.map(value => value.buildAwsValue()))(
        _.trafficMirrorFilter
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.wrap(buildAwsValue())
}
object CreateTrafficMirrorFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorFilterResponse =
      zio.aws.ec2.model.CreateTrafficMirrorFilterResponse(
        trafficMirrorFilter.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def trafficMirrorFilter
        : Optional[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly]
    def clientToken: Optional[String]
    def getTrafficMirrorFilter
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorFilter", trafficMirrorFilter)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
  ) extends zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly {
    override val trafficMirrorFilter
        : Optional[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilter())
        .map(value => zio.aws.ec2.model.TrafficMirrorFilter.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
  ): zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly = new Wrapper(
    impl
  )
}
