package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VersionDescription,
  LaunchTemplateName,
  LaunchTemplateId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLaunchTemplateVersionRequest(
    clientToken: Optional[String] = Optional.Absent,
    launchTemplateId: Optional[LaunchTemplateId] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    sourceVersion: Optional[String] = Optional.Absent,
    versionDescription: Optional[VersionDescription] = Optional.Absent,
    launchTemplateData: zio.aws.ec2.model.RequestLaunchTemplateData,
    resolveAlias: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest = {
    import CreateLaunchTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(
        versionDescription.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .launchTemplateData(launchTemplateData.buildAwsValue())
      .optionallyWith(resolveAlias.map(value => value: java.lang.Boolean))(
        _.resolveAlias
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.ReadOnly =
    zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.wrap(buildAwsValue())
}
object CreateLaunchTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLaunchTemplateVersionRequest =
      zio.aws.ec2.model.CreateLaunchTemplateVersionRequest(
        clientToken.map(value => value),
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        sourceVersion.map(value => value),
        versionDescription.map(value => value),
        launchTemplateData.asEditable,
        resolveAlias.map(value => value)
      )
    def clientToken: Optional[String]
    def launchTemplateId: Optional[LaunchTemplateId]
    def launchTemplateName: Optional[LaunchTemplateName]
    def sourceVersion: Optional[String]
    def versionDescription: Optional[VersionDescription]
    def launchTemplateData: zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly
    def resolveAlias: Optional[Boolean]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getVersionDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getLaunchTemplateData: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly
    ] = ZIO.succeed(launchTemplateData)
    def getResolveAlias: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resolveAlias", resolveAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
  ) extends zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val launchTemplateId: Optional[LaunchTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateId())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val sourceVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => value: String)
    override val versionDescription: Optional[VersionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.ec2.model.primitives.VersionDescription(value))
    override val launchTemplateData
        : zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly =
      zio.aws.ec2.model.RequestLaunchTemplateData
        .wrap(impl.launchTemplateData())
    override val resolveAlias: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resolveAlias())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
  ): zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
