package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClassicLinkDnsSupport(
    classicLinkDnsSupported: Optional[Boolean] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport = {
    import ClassicLinkDnsSupport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport
      .builder()
      .optionallyWith(
        classicLinkDnsSupported.map(value => value: java.lang.Boolean)
      )(_.classicLinkDnsSupported)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly =
    zio.aws.ec2.model.ClassicLinkDnsSupport.wrap(buildAwsValue())
}
object ClassicLinkDnsSupport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClassicLinkDnsSupport =
      zio.aws.ec2.model.ClassicLinkDnsSupport(
        classicLinkDnsSupported.map(value => value),
        vpcId.map(value => value)
      )
    def classicLinkDnsSupported: Optional[Boolean]
    def vpcId: Optional[String]
    def getClassicLinkDnsSupported: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("classicLinkDnsSupported", classicLinkDnsSupported)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport
  ) extends zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly {
    override val classicLinkDnsSupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classicLinkDnsSupported())
        .map(value => value: Boolean)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport
  ): zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly = new Wrapper(impl)
}
