package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVpnGatewayResponse(
    vpcAttachment: Optional[zio.aws.ec2.model.VpcAttachment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse = {
    import AttachVpnGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse
      .builder()
      .optionallyWith(vpcAttachment.map(value => value.buildAwsValue()))(
        _.vpcAttachment
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly =
    zio.aws.ec2.model.AttachVpnGatewayResponse.wrap(buildAwsValue())
}
object AttachVpnGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachVpnGatewayResponse =
      zio.aws.ec2.model
        .AttachVpnGatewayResponse(vpcAttachment.map(value => value.asEditable))
    def vpcAttachment: Optional[zio.aws.ec2.model.VpcAttachment.ReadOnly]
    def getVpcAttachment
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcAttachment.ReadOnly] =
      AwsError.unwrapOptionField("vpcAttachment", vpcAttachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse
  ) extends zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly {
    override val vpcAttachment
        : Optional[zio.aws.ec2.model.VpcAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcAttachment())
        .map(value => zio.aws.ec2.model.VpcAttachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse
  ): zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly = new Wrapper(impl)
}
