package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateIpamResourceDiscoveryResponse(
    ipamResourceDiscoveryAssociation: Optional[
      zio.aws.ec2.model.IpamResourceDiscoveryAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse = {
    import AssociateIpamResourceDiscoveryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse
      .builder()
      .optionallyWith(
        ipamResourceDiscoveryAssociation.map(value => value.buildAwsValue())
      )(_.ipamResourceDiscoveryAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateIpamResourceDiscoveryResponse.ReadOnly =
    zio.aws.ec2.model.AssociateIpamResourceDiscoveryResponse
      .wrap(buildAwsValue())
}
object AssociateIpamResourceDiscoveryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateIpamResourceDiscoveryResponse =
      zio.aws.ec2.model.AssociateIpamResourceDiscoveryResponse(
        ipamResourceDiscoveryAssociation.map(value => value.asEditable)
      )
    def ipamResourceDiscoveryAssociation
        : Optional[zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly]
    def getIpamResourceDiscoveryAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipamResourceDiscoveryAssociation",
      ipamResourceDiscoveryAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse
  ) extends zio.aws.ec2.model.AssociateIpamResourceDiscoveryResponse.ReadOnly {
    override val ipamResourceDiscoveryAssociation: Optional[
      zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamResourceDiscoveryAssociation())
      .map(value =>
        zio.aws.ec2.model.IpamResourceDiscoveryAssociation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse
  ): zio.aws.ec2.model.AssociateIpamResourceDiscoveryResponse.ReadOnly =
    new Wrapper(impl)
}
