package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalysisAclRule(
    cidr: Optional[String] = Optional.Absent,
    egress: Optional[Boolean] = Optional.Absent,
    portRange: Optional[zio.aws.ec2.model.PortRange] = Optional.Absent,
    protocol: Optional[String] = Optional.Absent,
    ruleAction: Optional[String] = Optional.Absent,
    ruleNumber: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisAclRule = {
    import AnalysisAclRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisAclRule
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(egress.map(value => value: java.lang.Boolean))(_.egress)
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(ruleAction.map(value => value: java.lang.String))(
        _.ruleAction
      )
      .optionallyWith(ruleNumber.map(value => value: java.lang.Integer))(
        _.ruleNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisAclRule.ReadOnly =
    zio.aws.ec2.model.AnalysisAclRule.wrap(buildAwsValue())
}
object AnalysisAclRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisAclRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisAclRule =
      zio.aws.ec2.model.AnalysisAclRule(
        cidr.map(value => value),
        egress.map(value => value),
        portRange.map(value => value.asEditable),
        protocol.map(value => value),
        ruleAction.map(value => value),
        ruleNumber.map(value => value)
      )
    def cidr: Optional[String]
    def egress: Optional[Boolean]
    def portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly]
    def protocol: Optional[String]
    def ruleAction: Optional[String]
    def ruleNumber: Optional[Integer]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getEgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("egress", egress)
    def getPortRange: ZIO[Any, AwsError, zio.aws.ec2.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("portRange", portRange)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getRuleAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisAclRule
  ) extends zio.aws.ec2.model.AnalysisAclRule.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val egress: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.egress())
      .map(value => value: Boolean)
    override val portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRange())
        .map(value => zio.aws.ec2.model.PortRange.wrap(value))
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
    override val ruleAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleAction())
      .map(value => value: String)
    override val ruleNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleNumber())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisAclRule
  ): zio.aws.ec2.model.AnalysisAclRule.ReadOnly = new Wrapper(impl)
}
