package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnConnectionOptions(
    enableAcceleration: Optional[Boolean] = Optional.Absent,
    staticRoutesOnly: Optional[Boolean] = Optional.Absent,
    localIpv4NetworkCidr: Optional[String] = Optional.Absent,
    remoteIpv4NetworkCidr: Optional[String] = Optional.Absent,
    localIpv6NetworkCidr: Optional[String] = Optional.Absent,
    remoteIpv6NetworkCidr: Optional[String] = Optional.Absent,
    outsideIpAddressType: Optional[String] = Optional.Absent,
    transportTransitGatewayAttachmentId: Optional[String] = Optional.Absent,
    tunnelInsideIpVersion: Optional[zio.aws.ec2.model.TunnelInsideIpVersion] =
      Optional.Absent,
    tunnelOptions: Optional[Iterable[zio.aws.ec2.model.TunnelOption]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnConnectionOptions = {
    import VpnConnectionOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
      .builder()
      .optionallyWith(
        enableAcceleration.map(value => value: java.lang.Boolean)
      )(_.enableAcceleration)
      .optionallyWith(staticRoutesOnly.map(value => value: java.lang.Boolean))(
        _.staticRoutesOnly
      )
      .optionallyWith(
        localIpv4NetworkCidr.map(value => value: java.lang.String)
      )(_.localIpv4NetworkCidr)
      .optionallyWith(
        remoteIpv4NetworkCidr.map(value => value: java.lang.String)
      )(_.remoteIpv4NetworkCidr)
      .optionallyWith(
        localIpv6NetworkCidr.map(value => value: java.lang.String)
      )(_.localIpv6NetworkCidr)
      .optionallyWith(
        remoteIpv6NetworkCidr.map(value => value: java.lang.String)
      )(_.remoteIpv6NetworkCidr)
      .optionallyWith(
        outsideIpAddressType.map(value => value: java.lang.String)
      )(_.outsideIpAddressType)
      .optionallyWith(
        transportTransitGatewayAttachmentId.map(value =>
          value: java.lang.String
        )
      )(_.transportTransitGatewayAttachmentId)
      .optionallyWith(tunnelInsideIpVersion.map(value => value.unwrap))(
        _.tunnelInsideIpVersion
      )
      .optionallyWith(
        tunnelOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tunnelOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnConnectionOptions.ReadOnly =
    zio.aws.ec2.model.VpnConnectionOptions.wrap(buildAwsValue())
}
object VpnConnectionOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnConnectionOptions =
      zio.aws.ec2.model.VpnConnectionOptions(
        enableAcceleration.map(value => value),
        staticRoutesOnly.map(value => value),
        localIpv4NetworkCidr.map(value => value),
        remoteIpv4NetworkCidr.map(value => value),
        localIpv6NetworkCidr.map(value => value),
        remoteIpv6NetworkCidr.map(value => value),
        outsideIpAddressType.map(value => value),
        transportTransitGatewayAttachmentId.map(value => value),
        tunnelInsideIpVersion.map(value => value),
        tunnelOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enableAcceleration: Optional[Boolean]
    def staticRoutesOnly: Optional[Boolean]
    def localIpv4NetworkCidr: Optional[String]
    def remoteIpv4NetworkCidr: Optional[String]
    def localIpv6NetworkCidr: Optional[String]
    def remoteIpv6NetworkCidr: Optional[String]
    def outsideIpAddressType: Optional[String]
    def transportTransitGatewayAttachmentId: Optional[String]
    def tunnelInsideIpVersion: Optional[zio.aws.ec2.model.TunnelInsideIpVersion]
    def tunnelOptions: Optional[List[zio.aws.ec2.model.TunnelOption.ReadOnly]]
    def getEnableAcceleration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableAcceleration", enableAcceleration)
    def getStaticRoutesOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("staticRoutesOnly", staticRoutesOnly)
    def getLocalIpv4NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localIpv4NetworkCidr", localIpv4NetworkCidr)
    def getRemoteIpv4NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remoteIpv4NetworkCidr", remoteIpv4NetworkCidr)
    def getLocalIpv6NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localIpv6NetworkCidr", localIpv6NetworkCidr)
    def getRemoteIpv6NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remoteIpv6NetworkCidr", remoteIpv6NetworkCidr)
    def getOutsideIpAddressType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outsideIpAddressType", outsideIpAddressType)
    def getTransportTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transportTransitGatewayAttachmentId",
        transportTransitGatewayAttachmentId
      )
    def getTunnelInsideIpVersion
        : ZIO[Any, AwsError, zio.aws.ec2.model.TunnelInsideIpVersion] =
      AwsError.unwrapOptionField("tunnelInsideIpVersion", tunnelInsideIpVersion)
    def getTunnelOptions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.TunnelOption.ReadOnly]] =
      AwsError.unwrapOptionField("tunnelOptions", tunnelOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
  ) extends zio.aws.ec2.model.VpnConnectionOptions.ReadOnly {
    override val enableAcceleration: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableAcceleration())
      .map(value => value: Boolean)
    override val staticRoutesOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.staticRoutesOnly())
      .map(value => value: Boolean)
    override val localIpv4NetworkCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.localIpv4NetworkCidr())
      .map(value => value: String)
    override val remoteIpv4NetworkCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteIpv4NetworkCidr())
      .map(value => value: String)
    override val localIpv6NetworkCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.localIpv6NetworkCidr())
      .map(value => value: String)
    override val remoteIpv6NetworkCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteIpv6NetworkCidr())
      .map(value => value: String)
    override val outsideIpAddressType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outsideIpAddressType())
      .map(value => value: String)
    override val transportTransitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transportTransitGatewayAttachmentId())
        .map(value => value: String)
    override val tunnelInsideIpVersion
        : Optional[zio.aws.ec2.model.TunnelInsideIpVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tunnelInsideIpVersion())
        .map(value => zio.aws.ec2.model.TunnelInsideIpVersion.wrap(value))
    override val tunnelOptions
        : Optional[List[zio.aws.ec2.model.TunnelOption.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tunnelOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TunnelOption.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnectionOptions
  ): zio.aws.ec2.model.VpnConnectionOptions.ReadOnly = new Wrapper(impl)
}
