package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TransitGatewayVpcAttachment(
    transitGatewayAttachmentId: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    vpcOwnerId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment = {
    import TransitGatewayVpcAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(vpcOwnerId.map(value => value: java.lang.String))(
        _.vpcOwnerId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(buildAwsValue())
}
object TransitGatewayVpcAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayVpcAttachment =
      zio.aws.ec2.model.TransitGatewayVpcAttachment(
        transitGatewayAttachmentId.map(value => value),
        transitGatewayId.map(value => value),
        vpcId.map(value => value),
        vpcOwnerId.map(value => value),
        state.map(value => value),
        subnetIds.map(value => value),
        creationTime.map(value => value),
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Optional[String]
    def transitGatewayId: Optional[String]
    def vpcId: Optional[String]
    def vpcOwnerId: Optional[String]
    def state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def subnetIds: Optional[List[String]]
    def creationTime: Optional[DateTime]
    def options: Optional[
      zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.ReadOnly
    ]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcOwnerId", vpcOwnerId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
  ) extends zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly {
    override val transitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachmentId())
        .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val vpcOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcOwnerId())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value)
        )
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val options: Optional[
      zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayVpcAttachmentOptions.wrap(value)
      )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment
  ): zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly = new Wrapper(impl)
}
