package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Storage(
    s3: Optional[zio.aws.ec2.model.S3Storage] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Storage = {
    import Storage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Storage
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Storage.ReadOnly =
    zio.aws.ec2.model.Storage.wrap(buildAwsValue())
}
object Storage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Storage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Storage =
      zio.aws.ec2.model.Storage(s3.map(value => value.asEditable))
    def s3: Optional[zio.aws.ec2.model.S3Storage.ReadOnly]
    def getS3: ZIO[Any, AwsError, zio.aws.ec2.model.S3Storage.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Storage
  ) extends zio.aws.ec2.model.Storage.ReadOnly {
    override val s3: Optional[zio.aws.ec2.model.S3Storage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.ec2.model.S3Storage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Storage
  ): zio.aws.ec2.model.Storage.ReadOnly = new Wrapper(impl)
}
