package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ResourceType
  ): zio.aws.ec2.model.ResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.CAPACITY_RESERVATION =>
      val r = `capacity-reservation`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.CLIENT_VPN_ENDPOINT =>
      val r = `client-vpn-endpoint`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.CUSTOMER_GATEWAY =>
      val r = `customer-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.CARRIER_GATEWAY =>
      val r = `carrier-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.COIP_POOL =>
      val r = `coip-pool`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.DEDICATED_HOST =>
      val r = `dedicated-host`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.DHCP_OPTIONS =>
      val r = `dhcp-options`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.EGRESS_ONLY_INTERNET_GATEWAY =>
      val r = `egress-only-internet-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.ELASTIC_IP =>
      val r = `elastic-ip`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.ELASTIC_GPU =>
      val r = `elastic-gpu`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.EXPORT_IMAGE_TASK =>
      val r = `export-image-task`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.EXPORT_INSTANCE_TASK =>
      val r = `export-instance-task`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.FLEET =>
      val r = fleet
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.FPGA_IMAGE =>
      val r = `fpga-image`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.HOST_RESERVATION =>
      val r = `host-reservation`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IMAGE =>
      val r = image
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IMPORT_IMAGE_TASK =>
      val r = `import-image-task`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IMPORT_SNAPSHOT_TASK =>
      val r = `import-snapshot-task`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.INSTANCE =>
      val r = instance
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.INSTANCE_EVENT_WINDOW =>
      val r = `instance-event-window`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.INTERNET_GATEWAY =>
      val r = `internet-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IPAM =>
      val r = ipam
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IPAM_POOL =>
      val r = `ipam-pool`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IPAM_SCOPE =>
      val r = `ipam-scope`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IPV4_POOL_EC2 =>
      val r = `ipv4pool-ec2`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.IPV6_POOL_EC2 =>
      val r = `ipv6pool-ec2`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.KEY_PAIR =>
      val r = `key-pair`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LAUNCH_TEMPLATE =>
      val r = `launch-template`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY =>
      val r = `local-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_ROUTE_TABLE =>
      val r = `local-gateway-route-table`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_VIRTUAL_INTERFACE =>
      val r = `local-gateway-virtual-interface`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP =>
      val r = `local-gateway-virtual-interface-group`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION =>
      val r = `local-gateway-route-table-vpc-association`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION =>
      val r = `local-gateway-route-table-virtual-interface-group-association`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NATGATEWAY =>
      val r = natgateway
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_ACL =>
      val r = `network-acl`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INTERFACE =>
      val r = `network-interface`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_ANALYSIS =>
      val r = `network-insights-analysis`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_PATH =>
      val r = `network-insights-path`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_ACCESS_SCOPE =>
      val r = `network-insights-access-scope`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS =>
      val r = `network-insights-access-scope-analysis`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.PLACEMENT_GROUP =>
      val r = `placement-group`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.PREFIX_LIST =>
      val r = `prefix-list`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.REPLACE_ROOT_VOLUME_TASK =>
      val r = `replace-root-volume-task`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.RESERVED_INSTANCES =>
      val r = `reserved-instances`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.ROUTE_TABLE =>
      val r = `route-table`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SECURITY_GROUP =>
      val r = `security-group`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SECURITY_GROUP_RULE =>
      val r = `security-group-rule`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SNAPSHOT =>
      val r = snapshot
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SPOT_FLEET_REQUEST =>
      val r = `spot-fleet-request`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SPOT_INSTANCES_REQUEST =>
      val r = `spot-instances-request`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SUBNET =>
      val r = subnet
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.SUBNET_CIDR_RESERVATION =>
      val r = `subnet-cidr-reservation`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_FILTER =>
      val r = `traffic-mirror-filter`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_SESSION =>
      val r = `traffic-mirror-session`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_TARGET =>
      val r = `traffic-mirror-target`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY =>
      val r = `transit-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_ATTACHMENT =>
      val r = `transit-gateway-attachment`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_CONNECT_PEER =>
      val r = `transit-gateway-connect-peer`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_MULTICAST_DOMAIN =>
      val r = `transit-gateway-multicast-domain`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_POLICY_TABLE =>
      val r = `transit-gateway-policy-table`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_ROUTE_TABLE =>
      val r = `transit-gateway-route-table`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT =>
      val r = `transit-gateway-route-table-announcement`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VOLUME =>
      val r = volume
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC =>
      val r = vpc
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT =>
      val r = `vpc-endpoint`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_CONNECTION =>
      val r = `vpc-endpoint-connection`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_SERVICE =>
      val r = `vpc-endpoint-service`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_SERVICE_PERMISSION =>
      val r = `vpc-endpoint-service-permission`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_PEERING_CONNECTION =>
      val r = `vpc-peering-connection`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPN_CONNECTION =>
      val r = `vpn-connection`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPN_GATEWAY =>
      val r = `vpn-gateway`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_FLOW_LOG =>
      val r = `vpc-flow-log`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.CAPACITY_RESERVATION_FLEET =>
      val r = `capacity-reservation-fleet`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_FILTER_RULE =>
      val r = `traffic-mirror-filter-rule`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_CONNECTION_DEVICE_TYPE =>
      val r = `vpc-endpoint-connection-device-type`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_INSTANCE =>
      val r = `verified-access-instance`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_GROUP =>
      val r = `verified-access-group`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_ENDPOINT =>
      val r = `verified-access-endpoint`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_POLICY =>
      val r = `verified-access-policy`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_TRUST_PROVIDER =>
      val r = `verified-access-trust-provider`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPN_CONNECTION_DEVICE_TYPE =>
      val r = `vpn-connection-device-type`
      r
    case software.amazon.awssdk.services.ec2.model.ResourceType.VPC_BLOCK_PUBLIC_ACCESS_EXCLUSION =>
      val r = `vpc-block-public-access-exclusion`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `capacity-reservation` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.CAPACITY_RESERVATION
  }
  case object `client-vpn-endpoint` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.CLIENT_VPN_ENDPOINT
  }
  case object `customer-gateway` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.CUSTOMER_GATEWAY
  }
  case object `carrier-gateway` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.CARRIER_GATEWAY
  }
  case object `coip-pool` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.COIP_POOL
  }
  case object `dedicated-host` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.DEDICATED_HOST
  }
  case object `dhcp-options` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.DHCP_OPTIONS
  }
  case object `egress-only-internet-gateway`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.EGRESS_ONLY_INTERNET_GATEWAY
  }
  case object `elastic-ip` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.ELASTIC_IP
  }
  case object `elastic-gpu` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.ELASTIC_GPU
  }
  case object `export-image-task` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.EXPORT_IMAGE_TASK
  }
  case object `export-instance-task` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.EXPORT_INSTANCE_TASK
  }
  case object fleet extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.FLEET
  }
  case object `fpga-image` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.FPGA_IMAGE
  }
  case object `host-reservation` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.HOST_RESERVATION
  }
  case object image extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IMAGE
  }
  case object `import-image-task` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IMPORT_IMAGE_TASK
  }
  case object `import-snapshot-task` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IMPORT_SNAPSHOT_TASK
  }
  case object instance extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.INSTANCE
  }
  case object `instance-event-window` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.INSTANCE_EVENT_WINDOW
  }
  case object `internet-gateway` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.INTERNET_GATEWAY
  }
  case object ipam extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IPAM
  }
  case object `ipam-pool` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IPAM_POOL
  }
  case object `ipam-scope` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IPAM_SCOPE
  }
  case object `ipv4pool-ec2` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IPV4_POOL_EC2
  }
  case object `ipv6pool-ec2` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.IPV6_POOL_EC2
  }
  case object `key-pair` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.KEY_PAIR
  }
  case object `launch-template` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LAUNCH_TEMPLATE
  }
  case object `local-gateway` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY
  }
  case object `local-gateway-route-table`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_ROUTE_TABLE
  }
  case object `local-gateway-virtual-interface`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_VIRTUAL_INTERFACE
  }
  case object `local-gateway-virtual-interface-group`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP
  }
  case object `local-gateway-route-table-vpc-association`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION
  }
  case object `local-gateway-route-table-virtual-interface-group-association`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION
  }
  case object natgateway extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NATGATEWAY
  }
  case object `network-acl` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_ACL
  }
  case object `network-interface` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INTERFACE
  }
  case object `network-insights-analysis`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_ANALYSIS
  }
  case object `network-insights-path` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_PATH
  }
  case object `network-insights-access-scope`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_ACCESS_SCOPE
  }
  case object `network-insights-access-scope-analysis`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS
  }
  case object `placement-group` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.PLACEMENT_GROUP
  }
  case object `prefix-list` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.PREFIX_LIST
  }
  case object `replace-root-volume-task`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.REPLACE_ROOT_VOLUME_TASK
  }
  case object `reserved-instances` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.RESERVED_INSTANCES
  }
  case object `route-table` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.ROUTE_TABLE
  }
  case object `security-group` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SECURITY_GROUP
  }
  case object `security-group-rule` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SECURITY_GROUP_RULE
  }
  case object snapshot extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SNAPSHOT
  }
  case object `spot-fleet-request` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SPOT_FLEET_REQUEST
  }
  case object `spot-instances-request` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SPOT_INSTANCES_REQUEST
  }
  case object subnet extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SUBNET
  }
  case object `subnet-cidr-reservation` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.SUBNET_CIDR_RESERVATION
  }
  case object `traffic-mirror-filter` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_FILTER
  }
  case object `traffic-mirror-session` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_SESSION
  }
  case object `traffic-mirror-target` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_TARGET
  }
  case object `transit-gateway` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY
  }
  case object `transit-gateway-attachment`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_ATTACHMENT
  }
  case object `transit-gateway-connect-peer`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_CONNECT_PEER
  }
  case object `transit-gateway-multicast-domain`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_MULTICAST_DOMAIN
  }
  case object `transit-gateway-policy-table`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_POLICY_TABLE
  }
  case object `transit-gateway-route-table`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_ROUTE_TABLE
  }
  case object `transit-gateway-route-table-announcement`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT
  }
  case object volume extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VOLUME
  }
  case object vpc extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC
  }
  case object `vpc-endpoint` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT
  }
  case object `vpc-endpoint-connection` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_CONNECTION
  }
  case object `vpc-endpoint-service` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_SERVICE
  }
  case object `vpc-endpoint-service-permission`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_SERVICE_PERMISSION
  }
  case object `vpc-peering-connection` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_PEERING_CONNECTION
  }
  case object `vpn-connection` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPN_CONNECTION
  }
  case object `vpn-gateway` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPN_GATEWAY
  }
  case object `vpc-flow-log` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_FLOW_LOG
  }
  case object `capacity-reservation-fleet`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.CAPACITY_RESERVATION_FLEET
  }
  case object `traffic-mirror-filter-rule`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.TRAFFIC_MIRROR_FILTER_RULE
  }
  case object `vpc-endpoint-connection-device-type`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_ENDPOINT_CONNECTION_DEVICE_TYPE
  }
  case object `verified-access-instance`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_INSTANCE
  }
  case object `verified-access-group` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_GROUP
  }
  case object `verified-access-endpoint`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_ENDPOINT
  }
  case object `verified-access-policy` extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_POLICY
  }
  case object `verified-access-trust-provider`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VERIFIED_ACCESS_TRUST_PROVIDER
  }
  case object `vpn-connection-device-type`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPN_CONNECTION_DEVICE_TYPE
  }
  case object `vpc-block-public-access-exclusion`
      extends zio.aws.ec2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ResourceType =
      software.amazon.awssdk.services.ec2.model.ResourceType.VPC_BLOCK_PUBLIC_ACCESS_EXCLUSION
  }
}
