package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetFpgaImageAttributeResponse(
    returnValue: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse = {
    import ResetFpgaImageAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly =
    zio.aws.ec2.model.ResetFpgaImageAttributeResponse.wrap(buildAwsValue())
}
object ResetFpgaImageAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetFpgaImageAttributeResponse =
      zio.aws.ec2.model
        .ResetFpgaImageAttributeResponse(returnValue.map(value => value))
    def returnValue: Optional[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse
  ) extends zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse
  ): zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
