package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class ReservedInstancesListing(
    clientToken: Optional[String] = Optional.Absent,
    createDate: Optional[DateTime] = Optional.Absent,
    instanceCounts: Optional[Iterable[zio.aws.ec2.model.InstanceCount]] =
      Optional.Absent,
    priceSchedules: Optional[Iterable[zio.aws.ec2.model.PriceSchedule]] =
      Optional.Absent,
    reservedInstancesId: Optional[String] = Optional.Absent,
    reservedInstancesListingId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ListingStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    updateDate: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesListing = {
    import ReservedInstancesListing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesListing
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        instanceCounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceCounts)
      .optionallyWith(
        priceSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.priceSchedules)
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .optionallyWith(
        reservedInstancesListingId.map(value => value: java.lang.String)
      )(_.reservedInstancesListingId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(updateDate.map(value => DateTime.unwrap(value): Instant))(
        _.updateDate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesListing.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesListing.wrap(buildAwsValue())
}
object ReservedInstancesListing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesListing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesListing =
      zio.aws.ec2.model.ReservedInstancesListing(
        clientToken.map(value => value),
        createDate.map(value => value),
        instanceCounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        priceSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesId.map(value => value),
        reservedInstancesListingId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateDate.map(value => value)
      )
    def clientToken: Optional[String]
    def createDate: Optional[DateTime]
    def instanceCounts: Optional[List[zio.aws.ec2.model.InstanceCount.ReadOnly]]
    def priceSchedules: Optional[List[zio.aws.ec2.model.PriceSchedule.ReadOnly]]
    def reservedInstancesId: Optional[String]
    def reservedInstancesListingId: Optional[String]
    def status: Optional[zio.aws.ec2.model.ListingStatus]
    def statusMessage: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def updateDate: Optional[DateTime]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getInstanceCounts
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceCount.ReadOnly]] =
      AwsError.unwrapOptionField("instanceCounts", instanceCounts)
    def getPriceSchedules
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PriceSchedule.ReadOnly]] =
      AwsError.unwrapOptionField("priceSchedules", priceSchedules)
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
    def getReservedInstancesListingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstancesListingId",
        reservedInstancesListingId
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.ListingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateDate", updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesListing
  ) extends zio.aws.ec2.model.ReservedInstancesListing.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val createDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceCounts
        : Optional[List[zio.aws.ec2.model.InstanceCount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceCount.wrap(item)
          }.toList
        )
    override val priceSchedules
        : Optional[List[zio.aws.ec2.model.PriceSchedule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priceSchedules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PriceSchedule.wrap(item)
          }.toList
        )
    override val reservedInstancesId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstancesId())
      .map(value => value: String)
    override val reservedInstancesListingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstancesListingId())
        .map(value => value: String)
    override val status: Optional[zio.aws.ec2.model.ListingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ListingStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val updateDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesListing
  ): zio.aws.ec2.model.ReservedInstancesListing.ReadOnly = new Wrapper(impl)
}
