package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RequestSpotFleetRequest(
    spotFleetRequestConfig: zio.aws.ec2.model.SpotFleetRequestConfigData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest = {
    import RequestSpotFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest
      .builder()
      .spotFleetRequestConfig(spotFleetRequestConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotFleetRequest.ReadOnly =
    zio.aws.ec2.model.RequestSpotFleetRequest.wrap(buildAwsValue())
}
object RequestSpotFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotFleetRequest =
      zio.aws.ec2.model
        .RequestSpotFleetRequest(spotFleetRequestConfig.asEditable)
    def spotFleetRequestConfig
        : zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly
    def getSpotFleetRequestConfig: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly
    ] = ZIO.succeed(spotFleetRequestConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest
  ) extends zio.aws.ec2.model.RequestSpotFleetRequest.ReadOnly {
    override val spotFleetRequestConfig
        : zio.aws.ec2.model.SpotFleetRequestConfigData.ReadOnly =
      zio.aws.ec2.model.SpotFleetRequestConfigData
        .wrap(impl.spotFleetRequestConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest
  ): zio.aws.ec2.model.RequestSpotFleetRequest.ReadOnly = new Wrapper(impl)
}
