package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceRouteTableAssociationResponse(
    newAssociationId: Optional[String] = Optional.Absent,
    associationState: Optional[zio.aws.ec2.model.RouteTableAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse = {
    import ReplaceRouteTableAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse
      .builder()
      .optionallyWith(newAssociationId.map(value => value: java.lang.String))(
        _.newAssociationId
      )
      .optionallyWith(associationState.map(value => value.buildAwsValue()))(
        _.associationState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly =
    zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.wrap(buildAwsValue())
}
object ReplaceRouteTableAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRouteTableAssociationResponse =
      zio.aws.ec2.model.ReplaceRouteTableAssociationResponse(
        newAssociationId.map(value => value),
        associationState.map(value => value.asEditable)
      )
    def newAssociationId: Optional[String]
    def associationState
        : Optional[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly]
    def getNewAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newAssociationId", newAssociationId)
    def getAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RouteTableAssociationState.ReadOnly
    ] = AwsError.unwrapOptionField("associationState", associationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse
  ) extends zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly {
    override val newAssociationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newAssociationId())
      .map(value => value: String)
    override val associationState
        : Optional[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationState())
        .map(value => zio.aws.ec2.model.RouteTableAssociationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse
  ): zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
